# coding: UTF-8

import tkinter as tk
import tkinter.scrolledtext as st
import tkinter.ttk as ttk
import threading
import myvisa


# Instantiation of the NI VISA class
visa = None

# Main window
root = tk.Tk()
root.title( 'Sample')
root.resizable( 0, 0)

# Frame
frame1 = tk.Frame(root)
frame2 = tk.Frame(root)
frame3 = tk.Frame(root)
frame4 = tk.Frame(root)

# VISA address
label1 = tk.Label( frame1, text='VISA address', anchor = tk.E, width = 10)
label1.pack( side = tk.LEFT)

resource = tk.StringVar()
combobox1 = ttk.Combobox( frame1, textvariable = resource, width = 27)
combobox1.pack( side = tk.LEFT)

# Events when "Search" button is clicked
def button1_Click():
    combobox1.config(state = "disable")
    button1.config(state = "disable")
    button2.config(state = "disable")
    resource.set("Searching For Resources ...")
    t = threading.Thread(target=resourceThread)
    t.start()

def resourceThread():
    global visa
    visa = myvisa.Myvisa()
    if len(visa.get_resources()) > 0:
        combobox1.config(value = visa.get_resources())
        combobox1.current(0)
    else:
        resource.set("")
    visa.close()
    combobox1.config(state = "active")
    button1.config(state = "active")
    button2.config(state = "active")

button1 = tk.Button(frame1, text='Search', width = 10, command = button1_Click)
button1.pack( side = tk.LEFT, padx = 5)


# Events when "Connect" button is clicked
def button2_Click():
    global visa
    visa = myvisa.Myvisa()
    # Connect
    if not visa.open(resource.get()):
        return

    # Process for Enable/Disable on the buttons
    combobox1.config(state = "disable")
    button1.config(state = "disable")
    button2.config(state = "disable")
    button3.config(state = "active")
    button4.config(state = "active")

button2 = tk.Button(frame1, text='Connect', width = 10, command = button2_Click)
button2.pack( side = tk.LEFT, padx = 5)


# Events when "Disconnect" button is clicked
def button3_Click():
    # Disconnect
    global visa
    visa.close()

    # Process for Enable/Disable on the buttons
    combobox1.config(state = "active")
    button1.config(state = "active")
    button2.config(state = "active")
    button3.config(state = "disable")
    button4.config(state = "disable")

button3 = tk.Button(frame1, text='Disconnect', width = 10, command = button3_Click)
button3.config(state = "disable")
button3.pack( side = tk.LEFT, padx = 5)


# Commands
label2 = tk.Label( frame2, text='Commands', anchor = tk.E, width = 10)
label2.pack( side = tk.LEFT)

command = tk.StringVar()
command.set("*IDN?")
textbox2 = tk.Entry( frame2, textvariable = command, width = 30)
textbox2.pack( side = tk.LEFT)

# Events when "Transmit and Receive" button is clicked
def button4_Click():
    global visa
    button4.config(state = "disable")

    textbox4.insert(tk.INSERT, "<< " + command.get() + "\n")          # Output logs of transmitting data
    visa.send_query_msg(command.get(), int(timeout.get()) * 1000)     # Transmit and receive commands

    if "?" in command.get() :                                         # If the command contains "?"
        textbox4.insert(tk.INSERT, ">> " + visa.msg_buf + "\n")       # Output logs of receiving data

    button4.config(state = "active")


button4 = tk.Button(frame2, text='Transmit and Receive', width = 23, command = button4_Click)
button4.config(state = "disable")
button4.pack( side = tk.LEFT, padx = 5)


# Timeout
label3 = tk.Label( frame3, text='Timeout', anchor = tk.E, width = 10)
label3.pack( side = tk.LEFT)

timeout = tk.StringVar()
timeout.set("1")
textbox3 = tk.Entry( frame3, textvariable = timeout, width = 10)
textbox3.pack( side = tk.LEFT)

label4 = tk.Label( frame3, text='sec', anchor = tk.E)
label4.pack( side = tk.LEFT)


# Log
def ctrlEvent(event):
    if(12 == event.state and event.keysym=='c' ):   # Enable [Ctrl + C] key only
        return
    else:
        return "break"                              # Disable other key

textbox4 = st.ScrolledText( frame4, width = 60, height = 20)
textbox4.bind("<Key>", lambda e: ctrlEvent(e))      # Key bind
textbox4.pack( side = tk.LEFT)


# Events when "Clear" button is clicked
def button5_Click():
    textbox4.delete('1.0', 'end')

button5 = tk.Button(frame4, text='Clear', width = 10, command = button5_Click)
button5.pack( side = tk.TOP, padx = 5)

# Frame Placement
frame1.pack(anchor = tk.NW, padx = 20, pady = 10)
frame2.pack(anchor = tk.NW, padx = 20, pady = 10)
frame3.pack(anchor = tk.NW, padx = 20, pady = 10)
frame4.pack(anchor = tk.NW, padx = 20, pady = 10)


root.update() # Disp update

root.geometry( str(frame1.winfo_width() + 50) + 'x430')  # Window size

# Disp
root.mainloop()
